/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.applet;

import jade.content.lang.Codec;
import jade.content.lang.sl.SLCodec;
import jade.content.onto.Ontology;
import jade.content.onto.basic.Action;
import jade.content.onto.basic.Result;
import jade.core.AID;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.Deregister;
import jade.domain.FIPAAgentManagement.FIPAManagementOntology;
import jade.domain.FIPAAgentManagement.Modify;
import jade.domain.FIPAAgentManagement.Register;
import jade.domain.FIPAAgentManagement.Search;
import jade.domain.FIPAAgentManagement.SearchConstraints;
import jade.domain.FIPAAgentManagement.UnsupportedFunction;
import jade.domain.FIPAException;
import jade.lang.acl.ACLMessage;
import jade.tools.applet.AppletRequestProto;
import jade.tools.applet.DFAppletCommunicator;
import jade.tools.dfgui.DFGUI;
import jade.util.leap.ArrayList;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import java.util.Date;

public class FIPAAppletRequestProto
extends AppletRequestProto {
    Codec c;
    String action;
    Object dfd;
    private static Ontology o = FIPAManagementOntology.getInstance();
    AID receiver;
    DFGUI gui;
    DFAppletCommunicator dfApplet;
    ACLMessage lastMsg;

    FIPAAppletRequestProto(DFAppletCommunicator communicator, AID receiver, String actionName, Object agentDescription, SearchConstraints sc) throws FIPAException {
        super(communicator.getStream(), communicator.getParser(), new ACLMessage(16));
        this.gui = communicator.getGUI();
        this.dfApplet = communicator;
        this.reqMsg = new ACLMessage(16);
        this.reqMsg.addReceiver(receiver);
        this.reqMsg.setProtocol("fipa-request");
        this.reqMsg.setLanguage("fipa-sl");
        this.reqMsg.setOntology("FIPA-Agent-Management");
        this.reqMsg.setReplyWith("rw" + new Date().getTime());
        this.reqMsg.setConversationId("conv" + new Date().getTime());
        this.action = actionName;
        this.dfd = agentDescription;
        this.receiver = receiver;
        Action act = new Action();
        act.setActor(receiver);
        if (actionName.equalsIgnoreCase("register")) {
            Register action = new Register();
            action.setDescription(agentDescription);
            act.setAction(action);
        } else if (actionName.equalsIgnoreCase("deregister")) {
            Deregister action = new Deregister();
            action.setDescription(agentDescription);
            act.setAction(action);
        } else if (actionName.equalsIgnoreCase("modify")) {
            Modify action = new Modify();
            action.setDescription(agentDescription);
            act.setAction(action);
        } else if (actionName.equalsIgnoreCase("search")) {
            Search action = new Search();
            action.setDescription(agentDescription);
            action.setConstraints(sc);
            act.setAction(action);
        } else {
            throw new UnsupportedFunction();
        }
        this.c = new SLCodec();
        this.reqMsg.setContent(AppletRequestProto.encode(act, (SLCodec)this.c, o));
    }

    public List getSearchResult() throws FIPAException, NotYetReady {
        if (this.notYetReady) {
            throw new NotYetReady();
        }
        if (this.lastMsg.getPerformative() != 7) {
            throw new FIPAException(this.lastMsg);
        }
        Result r = AppletRequestProto.extractContent(this.lastMsg.getContent(), (SLCodec)this.c, o);
        Iterator i = r.getItems().iterator();
        ArrayList l = new ArrayList();
        while (i.hasNext()) {
            l.add(i.next());
        }
        return l;
    }

    public void handleInform(ACLMessage msg) {
        block12: {
            this.notYetReady = false;
            this.lastMsg = (ACLMessage)msg.clone();
            try {
                if (this.action.equalsIgnoreCase("register")) {
                    if (this.dfApplet.isADF((DFAgentDescription)this.dfd)) {
                        this.gui.addChildren(((DFAgentDescription)this.dfd).getName());
                    }
                    this.gui.addAgentDesc(((DFAgentDescription)this.dfd).getName());
                    this.gui.showStatusMsg("Registration of agent:" + ((DFAgentDescription)this.dfd).getName().getName() + " done.");
                    break block12;
                }
                if (this.action.equalsIgnoreCase("search")) {
                    try {
                        this.gui.showStatusMsg("Search request Processed. Ready for new request.");
                        this.gui.refreshLastSearchResults(this.getSearchResult(), msg.getSender());
                    }
                    catch (NotYetReady nyr) {
                    }
                    catch (FIPAException e) {}
                    break block12;
                }
                if (this.action.equalsIgnoreCase("deregister")) {
                    try {
                        this.gui.removeChildren(((DFAgentDescription)this.dfd).getName());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.gui.removeAgentDesc(((DFAgentDescription)this.dfd).getName(), this.dfApplet.getDescriptionOfThisDF().getName());
                    this.gui.showStatusMsg("Deregistration of agent: " + ((DFAgentDescription)this.dfd).getName().getName() + " done.");
                    break block12;
                }
                if (this.action.equalsIgnoreCase("modify")) {
                    this.gui.removeAgentDesc(((DFAgentDescription)this.dfd).getName(), this.dfApplet.getDescriptionOfThisDF().getName());
                    this.gui.addAgentDesc(((DFAgentDescription)this.dfd).getName());
                    this.gui.showStatusMsg("Modify of Agent: " + ((DFAgentDescription)this.dfd).getName().getName() + " done.");
                }
            }
            catch (NullPointerException e) {}
        }
    }

    protected void handleAgree(ACLMessage msg) {
        try {
            this.gui.showStatusMsg("Process your request & waiting for result..");
        }
        catch (NullPointerException e) {}
    }

    protected void handleNotUnderstood(ACLMessage msg) {
        this.notYetReady = false;
        this.lastMsg = (ACLMessage)msg.clone();
    }

    protected void handleOtherMessage(ACLMessage msg) {
    }

    protected void handleRefuse(ACLMessage msg) {
        this.notYetReady = false;
        this.lastMsg = (ACLMessage)msg.clone();
    }

    protected void handleFailure(ACLMessage msg) {
        this.notYetReady = false;
        this.lastMsg = (ACLMessage)msg.clone();
    }

    public static class NotYetReady
    extends Exception {
        NotYetReady() {
            super("Requested message is not ready yet.");
        }
    }
}

